 ; Ŀ
 ;   Instag & Pneutag - install an instrument tag with optional leader.    
 ;   Copyright 1997, 2010 by Rocket Software Ltd.                          
 ;   Croatians - they're not just little cubes of toast.                   
 ; 

 ; Ŀ
 ;   Instag - the mechanism.                                               
 ; 
 (DEFUN INSTAG (/ dimscl clay exlay pa pb paper)
  (setvar "cmdecho" 0)
  (setvar "orthomode" 0)
  (setvar "snapmode" 1)
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq dimscl (misps))
  (setq clay (getvar "clayer"))
  (setq exlay (tblsearch "layer" "instr"))
  (cond ((null exlay)
         (command ".layer" "m" "instr" "color" "yellow" "instr" ""))
        ((/= clay "INSTR")
         (setvar "clayer" "instr")))
  (if (setq pa (getpoint "Leader start or <Return> to omit: "))
      (setq pb (getpoint pa "\nTag centrepoint: "))
      (setq pb (getpoint "\nTag centrepoint: ")))
  (if (and pa (> (distance pa pb) (* dimscl 6)))
      (progn
           (setq paper (polar pb (angle pb pa) (* dimscl 6)))
           (command ".line" pa paper ""))
      (if pa (prompt "\nNo space for line.")))
  (command ".insert" "inst-tag" pb dimscl dimscl 0)
 (princ))
 ; Ŀ
 ;   Instag end.                                                           
 ; 

 ; Ŀ
 ;   Pom - find the prompts and defaults in a block definition.            
 ;   Standard Notes: 1. Entnext returns nil after the last entity in a     
 ;                      block definition.                                  
 ;                   2. An empty block has one subentity of type Endblk.   
 ;   Takes one argument: Namm, the block name.                             
 ;   Returns a list of lists: Prompt and Default value.                    
 ; 
 (DEFUN POM (namm / namm entt prom prlis)
  (setq namm (cdr (assoc -2 (tblsearch "block" namm))))
  (while (and namm (setq entt (entget namm)))            ; the whole thing
         (setq namm (entnext namm))                      ; next subentity ename
         (setq prom (cdr (assoc 3 entt)))
         (setq deff (cdr (assoc 1 entt)))
         (if prom (setq prlis (append prlis (list (list prom deff))))))
 prlis)
 ; Ŀ
 ;   Pom end.                                                              
 ; 

 ; Ŀ
 ;   Pneutag - insert the tag for a pneumatic instrument.                  
 ; 
 (DEFUN C:PNEUTAG (/ prlis prom vall)
  (instag)
  (if (= (getvar "attdia") 0)
      (progn
           (setq prlis (pom "INST-TAG"))
           (while (setq prsub (car prlis))
                  (setq prlis (cdr prlis))
                  (setq prom (car prsub))
                  (setq defl (cadr prsub))
                  (if (/= defl "")
                      (progn
                           (setq vall (getstring (strcat "\n" prom
                                                         " <" defl ">: ")))
                           (if (= vall "") (setq vall defl)))
                      (setq vall (getstring (strcat "\n" prom ": "))))
                  (command vall))))
  (if (= vall "100") (prompt "\nYour Mama."))
 ; Ŀ
 ;   Change the tag to the correct linetype.                               
 ; 
  (if (null (tblsearch "ltype" "phantom2"))
      (command ".linetype" "load" "phantom2" "acad" ""))
  (command ".change" (entlast) "" "p" "lt" "phantom2" "")
 (princ))

 ; Ŀ
 ;   Instag - insert the tag for an electrical instrument.                 
 ; 
 (DEFUN C:INSTAG ()
  (instag)
 (princ))